/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation;

import com.google.common.base.Suppliers;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.element.ScreenElement;
import com.zurrtum.create.client.ponder.Ponder;
import com.zurrtum.create.client.ponder.foundation.PonderIndex;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

@Environment(value=EnvType.CLIENT)
public class PonderTag
implements ScreenElement {
    private final class_2960 id;
    @Nullable
    private final TextureIconRenderer textureIcon;
    private final class_1799 mainItem;
    @Nullable
    private final Supplier<GuiGameElement.GuiItemRenderBuilder> itemIcon;

    public PonderTag(class_2960 id, @Nullable class_2960 textureIconLocation, class_1799 itemIcon, class_1799 mainItem) {
        this.id = id;
        this.textureIcon = textureIconLocation == null ? null : (graphics, poseStack, x, y) -> {
            poseStack.translate((float)x, (float)y);
            poseStack.scale(0.25f, 0.25f);
            graphics.method_25291(class_10799.field_56883, textureIconLocation, 0, 0, 0.0f, 0.0f, 0, 64, 64, 64, 64);
        };
        this.mainItem = mainItem;
        this.itemIcon = textureIconLocation == null && !itemIcon.method_7960() ? Suppliers.memoize(() -> (GuiGameElement.GuiItemRenderBuilder)((GuiGameElement.GuiItemRenderBuilder)GuiGameElement.of(itemIcon).scale(1.25f)).at(-2.0f, -2.0f)) : null;
    }

    public PonderTag(PonderTag tag, float scale) {
        this.id = tag.id;
        TextureIconRenderer prevTextureIcon = tag.textureIcon;
        this.textureIcon = prevTextureIcon == null ? null : (graphics, poseStack, x, y) -> {
            poseStack.scale(scale);
            prevTextureIcon.render(graphics, poseStack, x, y);
        };
        this.mainItem = tag.mainItem;
        this.itemIcon = prevTextureIcon == null && tag.itemIcon != null ? Suppliers.memoize(() -> (GuiGameElement.GuiItemRenderBuilder)tag.itemIcon.get().copy().scale(1.25f * scale)) : null;
    }

    public class_2960 getId() {
        return this.id;
    }

    public class_1799 getMainItem() {
        return this.mainItem;
    }

    public String getTitle() {
        return PonderIndex.getLangAccess().getTagName(this.id);
    }

    public String getDescription() {
        return PonderIndex.getLangAccess().getTagDescription(this.id);
    }

    @Override
    public void render(class_332 graphics, int x, int y) {
        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        if (this.textureIcon != null) {
            this.textureIcon.render(graphics, poseStack, x, y);
        } else if (this.itemIcon != null) {
            poseStack.translate((float)x, (float)y);
            this.itemIcon.get().render(graphics);
        }
        poseStack.popMatrix();
    }

    public void clear() {
        if (this.itemIcon != null) {
            this.itemIcon.get().clear();
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PonderTag)) {
            return false;
        }
        PonderTag otherTag = (PonderTag)other;
        return this.getId().equals((Object)otherTag.getId());
    }

    @Environment(value=EnvType.CLIENT)
    private static interface TextureIconRenderer {
        public void render(class_332 var1, Matrix3x2fStack var2, int var3, int var4);
    }

    @Environment(value=EnvType.CLIENT)
    public static final class Highlight {
        public static final class_2960 ALL = Ponder.asResource("_all");
    }
}

